import 'package:cached_network_image/cached_network_image.dart';
import 'package:easy_localization/easy_localization.dart';
import 'package:flutter/material.dart';
import 'package:wordpress_app/cards/comment_reply_card.dart';
import 'package:wordpress_app/services/app_service.dart';

import '../models/comment.dart';
import '../widgets/html_body/html_body.dart';

class CommentCard extends StatelessWidget {
  const CommentCard(
      {super.key,
      required this.allComments,
      required this.comment,
      required this.onReplyButtonPressed,
      required this.menuPopUp,
      required this.isCommentFlagged});

  final List<CommentModel> allComments;
  final CommentModel comment;
  final Function(CommentModel comment) onReplyButtonPressed;
  final Function(CommentModel comment) menuPopUp;
  final Function(int commentId) isCommentFlagged;

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Padding(
          padding: const EdgeInsets.symmetric(vertical: 12, horizontal: 0),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      border: Border.all(
                        color: Theme.of(context).primaryColor.withValues(alpha: 0.2),
                        width: 1.5,
                      ),
                    ),
                    child: CircleAvatar(
                      radius: 18,
                      backgroundColor: Colors.transparent,
                      child: CircleAvatar(
                        radius: 16.5,
                        backgroundImage: CachedNetworkImageProvider(comment.avatar.toString()),
                      ),
                    ),
                  ),
                  const SizedBox(width: 10),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Row(
                          children: [
                            Expanded(
                              child: Row(
                                children: [
                                  Flexible(
                                    child: Text(
                                      comment.author,
                                      maxLines: 1,
                                      overflow: TextOverflow.ellipsis,
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontWeight: FontWeight.w700,
                                        color: Theme.of(context).colorScheme.onSurface,
                                      ),
                                    ),
                                  ),
                                  const SizedBox(width: 6),
                                  Container(
                                    padding: const EdgeInsets.symmetric(horizontal: 6, vertical: 2),
                                    decoration: BoxDecoration(
                                      color: Theme.of(context).colorScheme.surfaceContainerLow,
                                      borderRadius: BorderRadius.circular(4),
                                    ),
                                    child: Row(
                                      mainAxisSize: MainAxisSize.min,
                                      children: [
                                        Icon(
                                          Icons.schedule,
                                          size: 10,
                                          color: Theme.of(context).colorScheme.onSurfaceVariant,
                                        ),
                                        const SizedBox(width: 3),
                                        Text(
                                          AppService.getTime(comment.date, context),
                                          style: TextStyle(
                                            fontSize: 10,
                                            fontWeight: FontWeight.w500,
                                            color: Theme.of(context).colorScheme.onSurfaceVariant,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            menuPopUp(comment),
                          ],
                        ),
                        const SizedBox(height: 10),
                        isCommentFlagged(comment.id)
                            ? Container(
                                padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 8),
                                decoration: BoxDecoration(
                                  color: Theme.of(context).colorScheme.errorContainer.withValues(alpha: 0.2),
                                  borderRadius: BorderRadius.circular(6),
                                  border: Border.all(
                                    color: Theme.of(context).colorScheme.error.withValues(alpha: 0.3),
                                    width: 1,
                                  ),
                                ),
                                child: Row(
                                  mainAxisSize: MainAxisSize.min,
                                  children: [
                                    Icon(
                                      Icons.flag_rounded,
                                      size: 14,
                                      color: Theme.of(context).colorScheme.error,
                                    ),
                                    const SizedBox(width: 6),
                                    Text(
                                      'comment-flagged',
                                      style: TextStyle(
                                        fontSize: 12,
                                        fontWeight: FontWeight.w500,
                                        color: Theme.of(context).colorScheme.error,
                                      ),
                                    ).tr(),
                                  ],
                                ),
                              )
                            : HtmlBody(
                                content: comment.content.toString(),
                                isVideoEnabled: true,
                                isimageEnabled: true,
                                isIframeVideoEnabled: true,
                                textPadding: 0.0,
                              ),
                        const SizedBox(height: 8),
                        InkWell(
                          onTap: () => onReplyButtonPressed(comment),
                          borderRadius: BorderRadius.circular(6),
                          child: Container(
                            padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 6),
                            decoration: BoxDecoration(
                              color: Theme.of(context).primaryColor.withValues(alpha: 0.1),
                              borderRadius: BorderRadius.circular(6),
                            ),
                            child: Row(
                              mainAxisSize: MainAxisSize.min,
                              children: [
                                Icon(
                                  Icons.subdirectory_arrow_left_rounded,
                                  size: 14,
                                  color: Theme.of(context).colorScheme.primary,
                                ),
                                const SizedBox(width: 4),
                                Text(
                                  'reply'.tr(),
                                  style: TextStyle(
                                    fontSize: 12,
                                    fontWeight: FontWeight.w600,
                                    color: Theme.of(context).colorScheme.primary,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
        Divider(
          height: 1,
          thickness: 1,
          color: Theme.of(context).colorScheme.outline.withValues(alpha: 0.15),
        ),
        Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: allComments.map((e) {
            if (e.parent == comment.id) {
              return Padding(
                padding: const EdgeInsets.only(
                  left: 20,
                  right: 0,
                  top: 8,
                  bottom: 8,
                ),
                child: Container(
                  decoration: BoxDecoration(
                    border: Border(
                      left: BorderSide(
                        color: Theme.of(context).primaryColor.withValues(alpha: 0.3),
                        width: 2,
                      ),
                    ),
                  ),
                  child: Padding(
                    padding: const EdgeInsets.only(left: 16),
                    child: CommentReplyCard(
                      comment: e,
                      isCommentFlagged: isCommentFlagged,
                      menuPopUp: menuPopUp,
                    ),
                  ),
                ),
              );
            } else {
              return Container();
            }
          }).toList(),
        )
      ],
    );
  }
}
